//FloorMountingPostHoles.scad;

//Use FloorMountingPostHole four times 
//to generate four mounting post holes;

//FloorMountingPostHole generates one mounting 
//post hole centered at the origin, 
//resting on the XY plane and standing 
//vertically above that plane;
    
//On exit from this module, 
//each hole is a small cylinder;
//It doesn't become a hole until it is used 
//as the second argument of a 
//difference() command;

//The holes in the BL, BR, TR mounting posts 
//are PostHoleBigPhi = 2.5mm, 
//ready to be tapped for a 3mm screw;
//The hole in the TL mounting post 
//is PostHoleSmallPhi = 2.0mm, 
//ready to be tapped for a 2.5mm screw;

//2022_02_19: A genuine UNO wouldn't fit onto 
//the latest FloorTwo;  
//Somewhat arbitrarily I decided to make 
//all printed holes only ...SmallPhi;  
//If necessary, I will drill them before 
//tapping and will probably tap 2.5mm, 
//rather than 3mm;

include <UNO_Dimensions.scad>
use <UNO_FloorMountingPostHole.scad>;

module FloorMountingPostHoles()
{

echo("Begin FloorMountingPostHoles");
    
//DeltaZ is constant for all mounting posts;
DeltaZ = FloorZ -Fuzz;

//Four post holes for UNO;
echo("BL = ", PostUnoBLx, PostUnoBLy);
translate([PostUnoBLx, PostUnoBLy, DeltaZ])
    FloorMountingPostHole(PostUnoPhiSmallTap);

echo("BR = ", PostUnoBRx, PostUnoBRy);
translate([PostUnoBRx, PostUnoBRy, DeltaZ])
    FloorMountingPostHole(PostUnoPhiSmallTap);

echo("TR = ", PostUnoTRx, PostUnoTRy);
translate([PostUnoTRx, PostUnoTRy, DeltaZ])
    FloorMountingPostHole(PostUnoPhiSmallTap);

echo("TL = ", PostUnoTLx, PostUnoTLy);
translate([PostUnoTLx, PostUnoTLy, DeltaZ])
    FloorMountingPostHole(PostUnoPhiSmallTap);

}
//
